import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class CustomMiniButton extends StatelessWidget {
  final VoidCallback onTap;
  final Color color;
  final Color iconColor;
  final IconData? icon;
  final double size;
  final Widget? child;

  const CustomMiniButton(
      {super.key,
      required this.onTap,
      this.color = Style.white,
      this.iconColor = Style.black,
        this.size=52,
       this.icon,
        this.child
      });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
        onTap: onTap,
        child:  Container(
            width: size.r,
            height: size.r,
            decoration: BoxDecoration(
                color: color,
                borderRadius: BorderRadius.circular(10.r),
                //border: Border.all(color: AppStyle.black)
            ),
            child: Center(
              child: icon!= null ? Icon(
                icon,
                color: iconColor,
              ) : child,
            ),
          ),
        );
  }
}
